#include "llcc68_str.h"

const char *llcc68_status_to_str(const llcc68_status_t value)
{
  switch (value)
  {
    case LLCC68_STATUS_OK:
    {
      return (const char *) "LLCC68_STATUS_OK";
    }

    case LLCC68_STATUS_UNSUPPORTED_FEATURE:
    {
      return (const char *) "LLCC68_STATUS_UNSUPPORTED_FEATURE";
    }

    case LLCC68_STATUS_UNKNOWN_VALUE:
    {
      return (const char *) "LLCC68_STATUS_UNKNOWN_VALUE";
    }

    case LLCC68_STATUS_ERROR:
    {
      return (const char *) "LLCC68_STATUS_ERROR";
    }

    default:
    {
      return (const char *) "Unknown";
    }

  }

}

const char *llcc68_sleep_cfgs_to_str(const llcc68_sleep_cfgs_t value)
{
  switch (value)
  {
    case LLCC68_SLEEP_CFG_COLD_START:
    {
      return (const char *) "LLCC68_SLEEP_CFG_COLD_START";
    }

    case LLCC68_SLEEP_CFG_WARM_START:
    {
      return (const char *) "LLCC68_SLEEP_CFG_WARM_START";
    }

    default:
    {
      return (const char *) "Unknown";
    }

  }

}

const char *llcc68_standby_cfgs_to_str(const llcc68_standby_cfgs_t value)
{
  switch (value)
  {
    case LLCC68_STANDBY_CFG_RC:
    {
      return (const char *) "LLCC68_STANDBY_CFG_RC";
    }

    case LLCC68_STANDBY_CFG_XOSC:
    {
      return (const char *) "LLCC68_STANDBY_CFG_XOSC";
    }

    default:
    {
      return (const char *) "Unknown";
    }

  }

}

const char *llcc68_reg_mod_to_str(const llcc68_reg_mod_t value)
{
  switch (value)
  {
    case LLCC68_REG_MODE_LDO:
    {
      return (const char *) "LLCC68_REG_MODE_LDO";
    }

    case LLCC68_REG_MODE_DCDC:
    {
      return (const char *) "LLCC68_REG_MODE_DCDC";
    }

    default:
    {
      return (const char *) "Unknown";
    }

  }

}

const char *llcc68_fallback_modes_to_str(const llcc68_fallback_modes_t value)
{
  switch (value)
  {
    case LLCC68_FALLBACK_STDBY_RC:
    {
      return (const char *) "LLCC68_FALLBACK_STDBY_RC";
    }

    case LLCC68_FALLBACK_STDBY_XOSC:
    {
      return (const char *) "LLCC68_FALLBACK_STDBY_XOSC";
    }

    case LLCC68_FALLBACK_FS:
    {
      return (const char *) "LLCC68_FALLBACK_FS";
    }

    default:
    {
      return (const char *) "Unknown";
    }

  }

}

const char *llcc68_tcxo_ctrl_voltages_to_str(const llcc68_tcxo_ctrl_voltages_t value)
{
  switch (value)
  {
    case LLCC68_TCXO_CTRL_1_6V:
    {
      return (const char *) "LLCC68_TCXO_CTRL_1_6V";
    }

    case LLCC68_TCXO_CTRL_1_7V:
    {
      return (const char *) "LLCC68_TCXO_CTRL_1_7V";
    }

    case LLCC68_TCXO_CTRL_1_8V:
    {
      return (const char *) "LLCC68_TCXO_CTRL_1_8V";
    }

    case LLCC68_TCXO_CTRL_2_2V:
    {
      return (const char *) "LLCC68_TCXO_CTRL_2_2V";
    }

    case LLCC68_TCXO_CTRL_2_4V:
    {
      return (const char *) "LLCC68_TCXO_CTRL_2_4V";
    }

    case LLCC68_TCXO_CTRL_2_7V:
    {
      return (const char *) "LLCC68_TCXO_CTRL_2_7V";
    }

    case LLCC68_TCXO_CTRL_3_0V:
    {
      return (const char *) "LLCC68_TCXO_CTRL_3_0V";
    }

    case LLCC68_TCXO_CTRL_3_3V:
    {
      return (const char *) "LLCC68_TCXO_CTRL_3_3V";
    }

    default:
    {
      return (const char *) "Unknown";
    }

  }

}

const char *llcc68_pkt_type_to_str(const llcc68_pkt_type_t value)
{
  switch (value)
  {
    case LLCC68_PKT_TYPE_GFSK:
    {
      return (const char *) "LLCC68_PKT_TYPE_GFSK";
    }

    case LLCC68_PKT_TYPE_LORA:
    {
      return (const char *) "LLCC68_PKT_TYPE_LORA";
    }
/*
    case LLCC68_PKT_TYPE_LR_FHSS:
    {
      return (const char *) "LLCC68_PKT_TYPE_LR_FHSS";
    }
*/
    default:
    {
      return (const char *) "Unknown";
    }

  }

}

const char *llcc68_ramp_time_to_str(const llcc68_ramp_time_t value)
{
  switch (value)
  {
    case LLCC68_RAMP_10_US:
    {
      return (const char *) "LLCC68_RAMP_10_US";
    }

    case LLCC68_RAMP_20_US:
    {
      return (const char *) "LLCC68_RAMP_20_US";
    }

    case LLCC68_RAMP_40_US:
    {
      return (const char *) "LLCC68_RAMP_40_US";
    }

    case LLCC68_RAMP_80_US:
    {
      return (const char *) "LLCC68_RAMP_80_US";
    }

    case LLCC68_RAMP_200_US:
    {
      return (const char *) "LLCC68_RAMP_200_US";
    }

    case LLCC68_RAMP_800_US:
    {
      return (const char *) "LLCC68_RAMP_800_US";
    }

    case LLCC68_RAMP_1700_US:
    {
      return (const char *) "LLCC68_RAMP_1700_US";
    }

    case LLCC68_RAMP_3400_US:
    {
      return (const char *) "LLCC68_RAMP_3400_US";
    }

    default:
    {
      return (const char *) "Unknown";
    }

  }

}

const char *llcc68_gfsk_pulse_shape_to_str(const llcc68_gfsk_pulse_shape_t value)
{
  switch (value)
  {
    case LLCC68_GFSK_PULSE_SHAPE_OFF:
    {
      return (const char *) "LLCC68_GFSK_PULSE_SHAPE_OFF";
    }

    case LLCC68_GFSK_PULSE_SHAPE_BT_03:
    {
      return (const char *) "LLCC68_GFSK_PULSE_SHAPE_BT_03";
    }

    case LLCC68_GFSK_PULSE_SHAPE_BT_05:
    {
      return (const char *) "LLCC68_GFSK_PULSE_SHAPE_BT_05";
    }

    case LLCC68_GFSK_PULSE_SHAPE_BT_07:
    {
      return (const char *) "LLCC68_GFSK_PULSE_SHAPE_BT_07";
    }

    case LLCC68_GFSK_PULSE_SHAPE_BT_1:
    {
      return (const char *) "LLCC68_GFSK_PULSE_SHAPE_BT_1";
    }

    default:
    {
      return (const char *) "Unknown";
    }

  }

}

const char *llcc68_gfsk_bw_to_str(const llcc68_gfsk_bw_t value)
{
  switch (value)
  {
    case LLCC68_GFSK_BW_4800:
    {
      return (const char *) "LLCC68_GFSK_BW_4800";
    }

    case LLCC68_GFSK_BW_5800:
    {
      return (const char *) "LLCC68_GFSK_BW_5800";
    }

    case LLCC68_GFSK_BW_7300:
    {
      return (const char *) "LLCC68_GFSK_BW_7300";
    }

    case LLCC68_GFSK_BW_9700:
    {
      return (const char *) "LLCC68_GFSK_BW_9700";
    }

    case LLCC68_GFSK_BW_11700:
    {
      return (const char *) "LLCC68_GFSK_BW_11700";
    }

    case LLCC68_GFSK_BW_14600:
    {
      return (const char *) "LLCC68_GFSK_BW_14600";
    }

    case LLCC68_GFSK_BW_19500:
    {
      return (const char *) "LLCC68_GFSK_BW_19500";
    }

    case LLCC68_GFSK_BW_23400:
    {
      return (const char *) "LLCC68_GFSK_BW_23400";
    }

    case LLCC68_GFSK_BW_29300:
    {
      return (const char *) "LLCC68_GFSK_BW_29300";
    }

    case LLCC68_GFSK_BW_39000:
    {
      return (const char *) "LLCC68_GFSK_BW_39000";
    }

    case LLCC68_GFSK_BW_46900:
    {
      return (const char *) "LLCC68_GFSK_BW_46900";
    }

    case LLCC68_GFSK_BW_58600:
    {
      return (const char *) "LLCC68_GFSK_BW_58600";
    }

    case LLCC68_GFSK_BW_78200:
    {
      return (const char *) "LLCC68_GFSK_BW_78200";
    }

    case LLCC68_GFSK_BW_93800:
    {
      return (const char *) "LLCC68_GFSK_BW_93800";
    }

    case LLCC68_GFSK_BW_117300:
    {
      return (const char *) "LLCC68_GFSK_BW_117300";
    }

    case LLCC68_GFSK_BW_156200:
    {
      return (const char *) "LLCC68_GFSK_BW_156200";
    }

    case LLCC68_GFSK_BW_187200:
    {
      return (const char *) "LLCC68_GFSK_BW_187200";
    }

    case LLCC68_GFSK_BW_234300:
    {
      return (const char *) "LLCC68_GFSK_BW_234300";
    }

    case LLCC68_GFSK_BW_312000:
    {
      return (const char *) "LLCC68_GFSK_BW_312000";
    }

    case LLCC68_GFSK_BW_373600:
    {
      return (const char *) "LLCC68_GFSK_BW_373600";
    }

    case LLCC68_GFSK_BW_467000:
    {
      return (const char *) "LLCC68_GFSK_BW_467000";
    }

    default:
    {
      return (const char *) "Unknown";
    }

  }

}

const char *llcc68_lora_sf_to_str(const llcc68_lora_sf_t value)
{
  switch (value)
  {
    case LLCC68_LORA_SF5:
    {
      return (const char *) "LLCC68_LORA_SF5";
    }

    case LLCC68_LORA_SF6:
    {
      return (const char *) "LLCC68_LORA_SF6";
    }

    case LLCC68_LORA_SF7:
    {
      return (const char *) "LLCC68_LORA_SF7";
    }

    case LLCC68_LORA_SF8:
    {
      return (const char *) "LLCC68_LORA_SF8";
    }

    case LLCC68_LORA_SF9:
    {
      return (const char *) "LLCC68_LORA_SF9";
    }

    case LLCC68_LORA_SF10:
    {
      return (const char *) "LLCC68_LORA_SF10";
    }

    case LLCC68_LORA_SF11:
    {
      return (const char *) "LLCC68_LORA_SF11";
    }
    /*
    case LLCC68_LORA_SF12:
    {
      return (const char *) "LLCC68_LORA_SF12";
    }
	*/
    default:
    {
      return (const char *) "Unknown";
    }

  }

}

const char *llcc68_lora_bw_to_str(const llcc68_lora_bw_t value)
{
  switch (value)
  {
    case LLCC68_LORA_BW_500:
    {
      return (const char *) "LLCC68_LORA_BW_500";
    }

    case LLCC68_LORA_BW_250:
    {
      return (const char *) "LLCC68_LORA_BW_250";
    }

    case LLCC68_LORA_BW_125:
    {
      return (const char *) "LLCC68_LORA_BW_125";
    }

    case LLCC68_LORA_BW_062:
    {
      return (const char *) "LLCC68_LORA_BW_062";
    }

    case LLCC68_LORA_BW_041:
    {
      return (const char *) "LLCC68_LORA_BW_041";
    }

    case LLCC68_LORA_BW_031:
    {
      return (const char *) "LLCC68_LORA_BW_031";
    }

    case LLCC68_LORA_BW_020:
    {
      return (const char *) "LLCC68_LORA_BW_020";
    }

    case LLCC68_LORA_BW_015:
    {
      return (const char *) "LLCC68_LORA_BW_015";
    }

    case LLCC68_LORA_BW_010:
    {
      return (const char *) "LLCC68_LORA_BW_010";
    }

    case LLCC68_LORA_BW_007:
    {
      return (const char *) "LLCC68_LORA_BW_007";
    }

    default:
    {
      return (const char *) "Unknown";
    }

  }

}

const char *llcc68_lora_cr_to_str(const llcc68_lora_cr_t value)
{
  switch (value)
  {
    case LLCC68_LORA_CR_4_5:
    {
      return (const char *) "LLCC68_LORA_CR_4_5";
    }

    case LLCC68_LORA_CR_4_6:
    {
      return (const char *) "LLCC68_LORA_CR_4_6";
    }

    case LLCC68_LORA_CR_4_7:
    {
      return (const char *) "LLCC68_LORA_CR_4_7";
    }

    case LLCC68_LORA_CR_4_8:
    {
      return (const char *) "LLCC68_LORA_CR_4_8";
    }

    default:
    {
      return (const char *) "Unknown";
    }

  }

}

const char *llcc68_gfsk_preamble_detector_to_str(const llcc68_gfsk_preamble_detector_t value)
{
  switch (value)
  {
    case LLCC68_GFSK_PREAMBLE_DETECTOR_OFF:
    {
      return (const char *) "LLCC68_GFSK_PREAMBLE_DETECTOR_OFF";
    }

    case LLCC68_GFSK_PREAMBLE_DETECTOR_MIN_8BITS:
    {
      return (const char *) "LLCC68_GFSK_PREAMBLE_DETECTOR_MIN_8BITS";
    }

    case LLCC68_GFSK_PREAMBLE_DETECTOR_MIN_16BITS:
    {
      return (const char *) "LLCC68_GFSK_PREAMBLE_DETECTOR_MIN_16BITS";
    }

    case LLCC68_GFSK_PREAMBLE_DETECTOR_MIN_24BITS:
    {
      return (const char *) "LLCC68_GFSK_PREAMBLE_DETECTOR_MIN_24BITS";
    }

    case LLCC68_GFSK_PREAMBLE_DETECTOR_MIN_32BITS:
    {
      return (const char *) "LLCC68_GFSK_PREAMBLE_DETECTOR_MIN_32BITS";
    }

    default:
    {
      return (const char *) "Unknown";
    }

  }

}

const char *llcc68_gfsk_address_filtering_to_str(const llcc68_gfsk_address_filtering_t value)
{
  switch (value)
  {
    case LLCC68_GFSK_ADDRESS_FILTERING_DISABLE:
    {
      return (const char *) "LLCC68_GFSK_ADDRESS_FILTERING_DISABLE";
    }

    case LLCC68_GFSK_ADDRESS_FILTERING_NODE_ADDRESS:
    {
      return (const char *) "LLCC68_GFSK_ADDRESS_FILTERING_NODE_ADDRESS";
    }

    case LLCC68_GFSK_ADDRESS_FILTERING_NODE_AND_BROADCAST_ADDRESSES:
    {
      return (const char *) "LLCC68_GFSK_ADDRESS_FILTERING_NODE_AND_BROADCAST_ADDRESSES";
    }

    default:
    {
      return (const char *) "Unknown";
    }

  }

}

const char *llcc68_gfsk_pkt_len_modes_to_str(const llcc68_gfsk_pkt_len_modes_t value)
{
  switch (value)
  {
    case LLCC68_GFSK_PKT_FIX_LEN:
    {
      return (const char *) "LLCC68_GFSK_PKT_FIX_LEN";
    }

    case LLCC68_GFSK_PKT_VAR_LEN:
    {
      return (const char *) "LLCC68_GFSK_PKT_VAR_LEN";
    }

    default:
    {
      return (const char *) "Unknown";
    }

  }

}

const char *llcc68_gfsk_crc_types_to_str(const llcc68_gfsk_crc_types_t value)
{
  switch (value)
  {
    case LLCC68_GFSK_CRC_OFF:
    {
      return (const char *) "LLCC68_GFSK_CRC_OFF";
    }

    case LLCC68_GFSK_CRC_1_BYTE:
    {
      return (const char *) "LLCC68_GFSK_CRC_1_BYTE";
    }

    case LLCC68_GFSK_CRC_2_BYTES:
    {
      return (const char *) "LLCC68_GFSK_CRC_2_BYTES";
    }

    case LLCC68_GFSK_CRC_1_BYTE_INV:
    {
      return (const char *) "LLCC68_GFSK_CRC_1_BYTE_INV";
    }

    case LLCC68_GFSK_CRC_2_BYTES_INV:
    {
      return (const char *) "LLCC68_GFSK_CRC_2_BYTES_INV";
    }

    default:
    {
      return (const char *) "Unknown";
    }

  }

}

const char *llcc68_gfsk_dc_free_to_str(const llcc68_gfsk_dc_free_t value)
{
  switch (value)
  {
    case LLCC68_GFSK_DC_FREE_OFF:
    {
      return (const char *) "LLCC68_GFSK_DC_FREE_OFF";
    }

    case LLCC68_GFSK_DC_FREE_WHITENING:
    {
      return (const char *) "LLCC68_GFSK_DC_FREE_WHITENING";
    }

    default:
    {
      return (const char *) "Unknown";
    }

  }

}

const char *llcc68_lora_pkt_len_modes_to_str(const llcc68_lora_pkt_len_modes_t value)
{
  switch (value)
  {
    case LLCC68_LORA_PKT_EXPLICIT:
    {
      return (const char *) "LLCC68_LORA_PKT_EXPLICIT";
    }

    case LLCC68_LORA_PKT_IMPLICIT:
    {
      return (const char *) "LLCC68_LORA_PKT_IMPLICIT";
    }

    default:
    {
      return (const char *) "Unknown";
    }

  }

}

const char *llcc68_cad_symbs_to_str(const llcc68_cad_symbs_t value)
{
  switch (value)
  {
    case LLCC68_CAD_01_SYMB:
    {
      return (const char *) "LLCC68_CAD_01_SYMB";
    }

    case LLCC68_CAD_02_SYMB:
    {
      return (const char *) "LLCC68_CAD_02_SYMB";
    }

    case LLCC68_CAD_04_SYMB:
    {
      return (const char *) "LLCC68_CAD_04_SYMB";
    }

    case LLCC68_CAD_08_SYMB:
    {
      return (const char *) "LLCC68_CAD_08_SYMB";
    }

    case LLCC68_CAD_16_SYMB:
    {
      return (const char *) "LLCC68_CAD_16_SYMB";
    }

    default:
    {
      return (const char *) "Unknown";
    }

  }

}

const char *llcc68_cad_exit_modes_to_str(const llcc68_cad_exit_modes_t value)
{
  switch (value)
  {
    case LLCC68_CAD_ONLY:
    {
      return (const char *) "LLCC68_CAD_ONLY";
    }

    case LLCC68_CAD_RX:
    {
      return (const char *) "LLCC68_CAD_RX";
    }

    case LLCC68_CAD_LBT:
    {
      return (const char *) "LLCC68_CAD_LBT";
    }

    default:
    {
      return (const char *) "Unknown";
    }

  }

}

const char *llcc68_chip_modes_to_str(const llcc68_chip_modes_t value)
{
  switch (value)
  {
    case LLCC68_CHIP_MODE_UNUSED:
    {
      return (const char *) "LLCC68_CHIP_MODE_UNUSED";
    }

    case LLCC68_CHIP_MODE_RFU:
    {
      return (const char *) "LLCC68_CHIP_MODE_RFU";
    }

    case LLCC68_CHIP_MODE_STBY_RC:
    {
      return (const char *) "LLCC68_CHIP_MODE_STBY_RC";
    }

    case LLCC68_CHIP_MODE_STBY_XOSC:
    {
      return (const char *) "LLCC68_CHIP_MODE_STBY_XOSC";
    }

    case LLCC68_CHIP_MODE_FS:
    {
      return (const char *) "LLCC68_CHIP_MODE_FS";
    }

    case LLCC68_CHIP_MODE_RX:
    {
      return (const char *) "LLCC68_CHIP_MODE_RX";
    }

    case LLCC68_CHIP_MODE_TX:
    {
      return (const char *) "LLCC68_CHIP_MODE_TX";
    }

    default:
    {
      return (const char *) "Unknown";
    }

  }

}

const char *llcc68_cmd_status_to_str(const llcc68_cmd_status_t value)
{
  switch (value)
  {
    case LLCC68_CMD_STATUS_RESERVED:
    {
      return (const char *) "LLCC68_CMD_STATUS_RESERVED";
    }

    case LLCC68_CMD_STATUS_RFU:
    {
      return (const char *) "LLCC68_CMD_STATUS_RFU";
    }

    case LLCC68_CMD_STATUS_DATA_AVAILABLE:
    {
      return (const char *) "LLCC68_CMD_STATUS_DATA_AVAILABLE";
    }

    case LLCC68_CMD_STATUS_CMD_TIMEOUT:
    {
      return (const char *) "LLCC68_CMD_STATUS_CMD_TIMEOUT";
    }

    case LLCC68_CMD_STATUS_CMD_PROCESS_ERROR:
    {
      return (const char *) "LLCC68_CMD_STATUS_CMD_PROCESS_ERROR";
    }

    case LLCC68_CMD_STATUS_CMD_EXEC_FAILURE:
    {
      return (const char *) "LLCC68_CMD_STATUS_CMD_EXEC_FAILURE";
    }

    case LLCC68_CMD_STATUS_CMD_TX_DONE:
    {
      return (const char *) "LLCC68_CMD_STATUS_CMD_TX_DONE";
    }

    default:
    {
      return (const char *) "Unknown";
    }

  }

}

