/********************************************************************************
 * File Name          : startup_cx32l003.S
 * Author             : MCD Application Team / B.VERNOUX (based on STM32 startup_stm32c031c6tx.s)
 * Version            : V1.0.0
 * Date               : 24 Aug 2023
 * Description        : CX32L003 vector table for GCC ARM Embedded
 *                      toolchain.
 *                      This module performs:
 *                      - Set the initial SP
 *                      - Set the initial PC == Reset_Handler
 *                      - Set the vector table entries with the exceptions ISR address
 *                      - Configure the clock system
 *                      - Branches to main in the C library (which eventually
 *                        calls main()).
 *                      After Reset the CortexM0+ processor is in Thread mode,
 *                      priority is Privileged, and the Stack is set to Main.
 *******************************************************************************
 * @attention
 *
 * Copyright (c) 2022 STMicroelectronics.
 * All rights reserved.
 *
 * This software is licensed under terms that can be found in the LICENSE file
 * in the root directory of this software component.
 * If no LICENSE file comes with this software, it is provided AS-IS.
 *
 *******************************************************************************
*/

  .syntax unified
	.cpu cortex-m0plus
	.fpu softvfp
	.thumb

.global	g_pfnVectors
.global	Default_Handler

/* start address for the initialization values of the .data section.
defined in linker script */
.word _sidata
/* start address for the .data section. defined in linker script */
.word _sdata
/* end address for the .data section. defined in linker script */
.word _edata
/* start address for the .bss section. defined in linker script */
.word _sbss
/* end address for the .bss section. defined in linker script */
.word _ebss

  .section .text.Reset_Handler
  .weak Reset_Handler
  .type Reset_Handler, %function
Reset_Handler:
  ldr   r0, =_estack
  mov   sp, r0          /* set stack pointer */

/* Copy the data segment initializers from flash to SRAM */
  movs r1, #0
  b LoopCopyDataInit

CopyDataInit:
  ldr r3, =_sidata
  ldr r3, [r3, r1]
  str r3, [r0, r1]
  adds r1, r1, #4

LoopCopyDataInit:
  ldr r0, =_sdata
  ldr r3, =_edata
  adds r2, r0, r1
  cmp r2, r3
  bcc CopyDataInit
  ldr r2, =_sbss
  b LoopFillZerobss
/* Zero fill the bss segment. */
FillZerobss:
  movs r3, #0
  str  r3, [r2]
  adds r2, r2, #4


LoopFillZerobss:
  ldr r3, = _ebss
  cmp r2, r3
  bcc FillZerobss

/* Call the clock system initialization function.*/
  bl  SystemInit
/* Call static constructors */
  bl __libc_init_array
/* Call the application's entry point.*/
  bl main

LoopForever:
    b LoopForever


.size Reset_Handler, .-Reset_Handler

/**
 * @brief  This is the code that gets called when the processor receives an
 *         unexpected interrupt.  This simply enters an infinite loop, preserving
 *         the system state for examination by a debugger.
 *
 * @param  None
 * @retval : None
*/
    .section .text.Default_Handler,"ax",%progbits
Default_Handler:
Infinite_Loop:
  b Infinite_Loop
  .size Default_Handler, .-Default_Handler
/******************************************************************************
*
* The minimal vector table for a Cortex M0.  Note that the proper constructs
* must be placed on this to ensure that it ends up at physical address
* 0x0000.0000.
*
******************************************************************************/
   .section .isr_vector,"a",%progbits
  .type g_pfnVectors, %object
  .size g_pfnVectors, .-g_pfnVectors


g_pfnVectors:
  .word  _estack           /* Initial stack pointer value */
  .word  Reset_Handler     /* Reset handler address */
  .word  NMI_Handler       /* NMI handler address */
  .word  HardFault_Handler /* HardFault handler address */
  .word  0                 /* Reserved */
  .word  0                 /* Reserved */
  .word  0                 /* Reserved */
  .word  0                 /* Reserved */
  .word  0                 /* Reserved */
  .word  0                 /* Reserved */
  .word  0                 /* Reserved */
  .word  SVC_Handler       /* SVCall handler address */
  .word  0                 /* Reserved */
  .word  0                 /* Reserved */
  .word  PendSV_Handler    /* PendSV handler address */
  .word  SysTick_Handler   /* SysTick handler address */
  /* External Interrupts */
  .word  GPIOA_IRQHandler
  .word  GPIOB_IRQHandler
  .word  GPIOC_IRQHandler
  .word  GPIOD_IRQHandler
  .word  FLASH_IRQHandler
  .word  0                 /* Reserved */
  .word  UART0_IRQHandler
  .word  UART1_IRQHandler
  .word  LPUART_IRQHandler
  .word  0                 /* Reserved */
  .word  SPI_IRQHandler
  .word  0                 /* Reserved */
  .word  I2C_IRQHandler
  .word  0                 /* Reserved */
  .word  TIM10_IRQHandler
  .word  TIM11_IRQHandler
  .word  LPTIM_IRQHandler
  .word  0                 /* Reserved */
  .word  TIM1_IRQHandler
  .word  TIM2_IRQHandler
  .word  0                 /* Reserved */
  .word  PCA_IRQHandler
  .word  WWDG_IRQHandler
  .word  IWDG_IRQHandler
  .word  ADC_IRQHandler
  .word  LVD_IRQHandler
  .word  VC_IRQHandler
  .word  0                 /* Reserved */
  .word  AWK_IRQHandler
  .word  OWIRE_IRQHandler
  .word  RTC_IRQHandler
  .word  CLKTRIM_IRQHandler

/*******************************************************************************
*
* Provide weak aliases for each Exception handler to the Default_Handler.
* As they are weak aliases, any function with the same name will override
* this definition.
*
*******************************************************************************/

  .weak      NMI_Handler
  .thumb_set NMI_Handler,Default_Handler

  .weak      HardFault_Handler
  .thumb_set HardFault_Handler,Default_Handler

  .weak      SVC_Handler
  .thumb_set SVC_Handler,Default_Handler

  .weak      PendSV_Handler
  .thumb_set PendSV_Handler,Default_Handler

  .weak      SysTick_Handler
  .thumb_set SysTick_Handler,Default_Handler

  .weak      GPIOA_IRQHandler
  .thumb_set GPIOA_IRQHandler,Default_Handler

  .weak      GPIOB_IRQHandler
  .thumb_set GPIOB_IRQHandler,Default_Handler

  .weak      GPIOC_IRQHandler
  .thumb_set GPIOC_IRQHandler,Default_Handler

  .weak      GPIOD_IRQHandler
  .thumb_set GPIOD_IRQHandler,Default_Handler

  .weak      FLASH_IRQHandler
  .thumb_set FLASH_IRQHandler,Default_Handler

  .weak      UART0_IRQHandler
  .thumb_set UART0_IRQHandler,Default_Handler

  .weak      UART1_IRQHandler
  .thumb_set UART1_IRQHandler,Default_Handler

  .weak      LPUART_IRQHandler
  .thumb_set LPUART_IRQHandler,Default_Handler

  .weak      SPI_IRQHandler
  .thumb_set SPI_IRQHandler,Default_Handler

  .weak      I2C_IRQHandler
  .thumb_set I2C_IRQHandler,Default_Handler

  .weak      TIM10_IRQHandler
  .thumb_set TIM10_IRQHandler,Default_Handler

  .weak      TIM11_IRQHandler
  .thumb_set TIM11_IRQHandler,Default_Handler

  .weak      LPTIM_IRQHandler
  .thumb_set LPTIM_IRQHandler,Default_Handler

  .weak      TIM1_IRQHandler
  .thumb_set TIM1_IRQHandler,Default_Handler

  .weak      TIM2_IRQHandler
  .thumb_set TIM2_IRQHandler,Default_Handler

  .weak      PCA_IRQHandler
  .thumb_set PCA_IRQHandler,Default_Handler

  .weak      WWDG_IRQHandler
  .thumb_set WWDG_IRQHandler,Default_Handler

  .weak      IWDG_IRQHandler
  .thumb_set IWDG_IRQHandler,Default_Handler

  .weak      ADC_IRQHandler
  .thumb_set ADC_IRQHandler,Default_Handler

  .weak      LVD_IRQHandler
  .thumb_set LVD_IRQHandler,Default_Handler

  .weak      VC_IRQHandler
  .thumb_set VC_IRQHandler,Default_Handler

  .weak      AWK_IRQHandler
  .thumb_set AWK_IRQHandler,Default_Handler

  .weak      OWIRE_IRQHandler
  .thumb_set OWIRE_IRQHandler,Default_Handler

  .weak      RTC_IRQHandler
  .thumb_set RTC_IRQHandler,Default_Handler

  .weak      CLKTRIM_IRQHandler
  .thumb_set CLKTRIM_IRQHandler,Default_Handler

