/**
******************************************************************************
* @file    cx32l003_ebyte_e220_uart.h
* @author  B.VERNOUX
* @Version V1.0.0
* @Date    04-Sep-2023
* @brief  This file contains definitions for:
*          - UART1 / SPI1(LLCC68) / GPIO on EBYTE E220 UART board (like E220-900T22D with CX32L003F8)
*
@verbatim
**/

/* Define to prevent recursive inclusion -------------------------------------*/
#ifndef __CX32L003_EBYTE_E220_UART_H
#define __CX32L003_EBYTE_E220_UART_H

#ifdef __cplusplus
 extern "C" {
#endif

/** @addtogroup BSP
  * @{
  */ 

/** @addtogroup CX32L003_EBYTE_E220_UART
  * @{
  */ 

/* Includes ------------------------------------------------------------------*/
#include "cx32l003_hal.h"
   
   
/** @defgroup CX32L003_EBYTE_E220_UART_Exported_Types CX32L003 E220_UART Exported Types
  * @{
  */

/**
  * @}
  */ 

/** @defgroup CX32L003_EBYTE_E220_UART_Exported_Constants CX32L003 E220_UART Exported Constants
  * @{
  */ 

/** 
  * @brief  Define for CX32L003_EBYTE_E220_UART board
  */ 
#if !defined (USE_CX32L003_EBYTE_E220_UART)
 #define USE_CX32L003_EBYTE_E220_UART
#endif

/** @defgroup CX32L003_EBYTE_E220_UART_PINS CX32L003 E220_UART PINS
  * @{
  */
/* RXD (UART1 TX PA1) */
#define RXD_GPIO_PORT	GPIOA
#define RXD_GPIO_PIN	GPIO_PIN_1
/* TXD (UART1 TX PA2) */
#define TXD_GPIO_PORT	GPIOA
#define TXD_GPIO_PIN	GPIO_PIN_2

/* AUX OUT PA3 by default */
#define AUX_GPIO_PORT	GPIOA
#define AUX_GPIO_PIN	GPIO_PIN_3

/* LLCC68_DIO1 (IRQ) IN PC3 by default */
#define LLCC68_DIO1_GPIO_PORT	GPIOC
#define LLCC68_DIO1_GPIO_PIN	GPIO_PIN_3
#define LLCC68_DIO1_GPIO_EXTI_IRQn   GPIOC_IRQn

/* LLCC68_SX_NRESET OUT (3V3=1=No Reset / GND=0=Reset) PB5 */
#define LLCC68_SX_NRESET_GPIO_PORT	GPIOB
#define LLCC68_SX_NRESET_GPIO_PIN	GPIO_PIN_5

/* LLCC68_BUSY IN (3V3=1=No Reset / GND=0=Reset) PD2 */
#define LLCC68_BUSY_GPIO_PORT	GPIOD
#define LLCC68_BUSY_GPIO_PIN	GPIO_PIN_2

/* M0(PD3) & M1(PD4) to be defined */

/**
  * @}
  */ 
    
/** @addtogroup CX32L003_EBYTE_E220_UART_BUS CX32L003 E220_UART BUS
  * @{
  */
/*############################### SPI ###################################*/
/**
  * @brief  SPI Interface pins
  *         used to control LoRa LLCC68 chipset
  */
extern SPI_HandleTypeDef hspi;

#define E220_UART_SPIx								SPI

/* PB4 SPI MASTER NSS AFR3 for LLCC68 SPI SLAVE NSS */
#define E220_UART_SPIx_NSS_GPIO_PORT				GPIOB
#define E220_UART_SPIx_NSS_PIN						GPIO_PIN_4

/* PC5 SPI MASTER SCK AFR3 for LLCC68 SPI SLAVE SCK */
#define E220_UART_SPIx_SCK_GPIO_PORT				GPIOC
#define E220_UART_SPIx_SCK_PIN						GPIO_PIN_5

/* PD5 SPI MASTER MISO AFR3 for LLCC68 SPI SLAVE MISO */
/* PD6 SPI MASTER MOSI AFR3 for LLCC68 SPI SLAVE MOSI */
#define E220_UART_SPIx_MISO_MOSI_GPIO_PORT			GPIOD
#define E220_UART_SPIx_MISO_PIN						GPIO_PIN_5
#define E220_UART_SPIx_MOSI_PIN						GPIO_PIN_6
/* Maximum Timeout values for flags waiting loops. These timeouts are not based
   on accurate values, they just guarantee that the application will not remain
   stuck if the SPI communication is corrupted.
   You may modify these timeout values depending on CPU frequency and application
   conditions (interrupts routines ...). */   
#define E220_UART_SPIx_TIMEOUT_MAX					1000

/*############################### I2C ###################################*/
/*#####  !!!!!Warning:I2C using same port as ADC's AIN1, AIN2!!!!!  #####*/
#if !defined (USE_CX32L003_EBYTE_E220_UART_ADC)
/**
  * @brief  I2C Interface pins
  *         used to control external eeprom
  */
#define E220_UART_I2Cx                                 SPI
#define E220_UART_I2Cx_CLK_ENABLE()                    __HAL_RCC_SPI_CLK_ENABLE()

#define E220_UART_I2Cx_SCL_GPIO_PORT                   GPIOC
#define E220_UART_I2Cx_SCL_PIN                         GPIO_PIN_3
#define E220_UART_I2Cx_SDA_PIN                         GPIO_PIN_4
#define E220_UART_I2Cx_SCL_SDA_GPIO_CLK_ENABLE()       __HAL_RCC_GPIOC_CLK_ENABLE()
#define E220_UART_I2Cx_SCL_SDA_GPIO_CLK_DISABLE()      __HAL_RCC_GPIOC_CLK_DISABLE()

/* Maximum Timeout values for flags waiting loops. These timeouts are not based
   on accurate values, they just guarantee that the application will not remain
   stuck if the SPI communication is corrupted.
   You may modify these timeout values depending on CPU frequency and application
   conditions (interrupts routines ...). */   
#define E220_UART_I2Cx_TIMEOUT_MAX                   1000
#endif 

/*############################ADC##############################*/
/*### !!!Warning:ADC's AIN1, AIN2 using same port as I2C!!! ###*/
#if defined (USE_CX32L003_EBYTE_E220_UART_ADC)
/**
  * @brief  ADC Interface pins
  *         used to measure adc input voltage
  */
#define E220_UART_ADCx                                 ADC
#define E220_UART_ADCx_CLK_ENABLE()                    __HAL_RCC_ADC_CLK_ENABLE()
#define E220_UART_ADCx_CLK_DISABLE()                 __HAL_RCC_ADC_CLK_DISABLE()
    
#define E220_UART_ADCx_GPIO_PORT                       GPIOC
#define E220_UART_ADCx_GPIO_PIN                        GPIO_PIN_3
#define E220_UART_ADCx_GPIO_CLK_ENABLE()               __HAL_RCC_GPIOC_CLK_ENABLE()
#define E220_UART_ADCx_GPIO_CLK_DISABLE()              __HAL_RCC_GPIOC_CLK_DISABLE()
#endif 

/**
  * @}
  */
    

/**
  * @}
  */
    
/** @addtogroup CX32L003_EBYTE_E220_UART_Exported_Functions
  * @{
  */
uint32_t BSP_GetVersion(void);

/** @addtogroup CX32L003_EBYTE_E220_UART_GPIO_Functions CX32L003 E220_UART GPIO Functions
  * @{
  */ 
void BSP_GPIO_Init(void);

/**
  * @}
  */

/** @addtogroup CX32L003_EBYTE_E220_UART_GPIO_Functions CX32L003 E220_UART SPI Functions
  * @{
  */
void BSP_SPI_Init(void);
void BSP_SPI_Write_Data(uint8_t *data, uint16_t data_size);
void BSP_SPI_Read_Data(uint8_t *data, uint8_t data_size);

/**
  * @}
  */

/** @addtogroup CX32L003_EBYTE_E220_UART_BUTTON_Functions CX32L003 E220_UART BUTTON Functions
  * @{
  */

/**
  * @}
  */

/**
  * @}
  */ /* End of group CX32L003_EBYTE_E220_UART_Exported_Functions */

/**
  * @}
  */ /* End of group CX32L003_EBYTE_E220_UART */

/**
  * @}
  */ /* End of group BSP */

#ifdef __cplusplus
}
#endif

#endif /* __CX32L003_EBYTE_E220_UART_H */


